/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;

public class ChannelBlock
extends Block
implements EntityBlock {
    private static final Component SIDE_IN;
    private static final Component SIDE_OUT;
    private static final Component SIDE_NONE;
    private static final Component DOWN_OUT;
    private static final Component DOWN_NONE;
    private static final Map<ChannelConnection, Component> SIDE_CONNECTION;
    public static final BooleanProperty DOWN;
    public static final BooleanProperty POWERED;
    public static final EnumProperty<ChannelConnection> NORTH;
    public static final EnumProperty<ChannelConnection> SOUTH;
    public static final EnumProperty<ChannelConnection> WEST;
    public static final EnumProperty<ChannelConnection> EAST;
    public static final Map<Direction, EnumProperty<ChannelConnection>> DIRECTION_MAP;
    private static final Map<Direction, VoxelShape> SIDE_BOUNDS;
    private static final VoxelShape[] BOUNDS;

    private static int makeKey(boolean down, boolean north, boolean south, boolean west, boolean east) {
        return (down ? 1 : 0) | (north ? 2 : 0) | (south ? 4 : 0) | (west ? 8 : 0) | (east ? 16 : 0);
    }

    public ChannelBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)ChannelConnection.NONE))).m_61124_(SOUTH, (Comparable)((Object)ChannelConnection.NONE))).m_61124_(WEST, (Comparable)((Object)ChannelConnection.NONE))).m_61124_(EAST, (Comparable)((Object)ChannelConnection.NONE)));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDS[ChannelBlock.makeKey((Boolean)state.m_61143_((Property)DOWN), ((ChannelConnection)((Object)state.m_61143_(NORTH))).canFlow(), ((ChannelConnection)((Object)state.m_61143_(SOUTH))).canFlow(), ((ChannelConnection)((Object)state.m_61143_(WEST))).canFlow(), ((ChannelConnection)((Object)state.m_61143_(EAST))).canFlow())];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DOWN, POWERED});
        DIRECTION_MAP.values().forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isFluidHandler(LevelAccessor world, Direction side, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).isPresent();
    }

    private boolean canConnect(LevelAccessor world, Direction side, BlockState facingState, BlockPos facingPos) {
        if (facingState.m_60734_() == this) {
            return true;
        }
        return ChannelBlock.isFluidHandler(world, side.m_122424_(), facingPos);
    }

    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction side) {
        BlockPos facingPos = pos.m_142300_(side);
        return this.canConnect(world, side, world.m_8055_(facingPos), facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(world.m_46753_(pos)));
        Direction side = context.m_43719_();
        if (side == Direction.DOWN) {
            return state;
        }
        if (side == Direction.UP) {
            return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)world, pos, Direction.DOWN)));
        }
        ChannelConnection connection = ChannelConnection.NONE;
        BlockPos placedOn = pos.m_142300_(side.m_122424_());
        if (world.m_8055_(placedOn).m_60713_((Block)this)) {
            Player player = context.m_43723_();
            connection = player != null && player.m_6144_() ? ChannelConnection.IN : ChannelConnection.OUT;
        } else if (ChannelBlock.isFluidHandler((LevelAccessor)world, side, placedOn)) {
            connection = ChannelConnection.OUT;
        }
        return (BlockState)state.m_61124_((Property)DIRECTION_MAP.get(side.m_122424_()), (Comparable)((Object)connection));
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && facingState.m_60795_()) {
                state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
            return state;
        }
        if (facing != Direction.UP) {
            EnumProperty<ChannelConnection> prop = DIRECTION_MAP.get(facing);
            if (facingState.m_60713_((Block)this)) {
                state = (BlockState)state.m_61124_(prop, (Comparable)((Object)((ChannelConnection)((Object)facingState.m_61143_((Property)DIRECTION_MAP.get(facing.m_122424_())))).getOpposite()));
            } else {
                ChannelConnection connection = (ChannelConnection)((Object)state.m_61143_(prop));
                if (connection != ChannelConnection.NONE && facingState.m_60795_()) {
                    state = (BlockState)state.m_61124_(prop, (Comparable)((Object)ChannelConnection.NONE));
                }
            }
        }
        return state;
    }

    @Nullable
    private BlockState interactWithSide(BlockState state, Level world, BlockPos pos, Player player, Direction side) {
        if (side == Direction.DOWN) {
            if (!((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && this.canConnect((LevelAccessor)world, pos, side)) {
                player.m_5661_(DOWN_OUT, true);
                return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                player.m_5661_(DOWN_NONE, true);
                return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
        } else {
            EnumProperty<ChannelConnection> prop = DIRECTION_MAP.get(side);
            ChannelConnection connection = (ChannelConnection)((Object)state.m_61143_(prop));
            BlockPos facingPos = pos.m_142300_(side);
            BlockState facingState = world.m_8055_(facingPos);
            ChannelConnection newConnect = connection.getNext(player.m_6144_());
            if (newConnect == ChannelConnection.OUT && facingState.m_60734_() != this && !ChannelBlock.isFluidHandler((LevelAccessor)world, side.m_122424_(), facingPos)) {
                newConnect = newConnect.getNext(player.m_6144_());
            }
            player.m_5661_(SIDE_CONNECTION.get((Object)newConnect), true);
            return (BlockState)state.m_61124_(prop, (Comparable)((Object)newConnect));
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Vec3 hitVec;
        Direction side;
        Direction hitFace = hit.m_82434_();
        if (player.m_21120_(hand).m_41720_() == this.m_5456_() && world.m_46859_(pos.m_142300_(hitFace))) {
            return InteractionResult.PASS;
        }
        Direction direction = side = hitFace == Direction.UP ? Direction.DOWN : hitFace;
        if (player.m_6144_() && side != Direction.DOWN) {
            side = side.m_122424_();
        }
        if ((hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_7094_() < 0.25) {
            side = Direction.NORTH;
        } else if (hitVec.m_7094_() > 0.75) {
            side = Direction.SOUTH;
        } else if (hitVec.m_7096_() < 0.25) {
            side = Direction.WEST;
        } else if (hitVec.m_7096_() > 0.75) {
            side = Direction.EAST;
        }
        BlockState newState = this.interactWithSide(state, world, pos, player, side);
        if (newState != null) {
            Direction finalSide = side;
            if (!world.f_46443_) {
                BlockEntityHelper.get(ChannelBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> te.refreshNeighbor(newState, finalSide));
            }
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.f_46443_) {
            boolean isPowered = worldIn.m_46753_(pos);
            if (isPowered != (Boolean)state.m_61143_((Property)POWERED)) {
                state = (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(isPowered && this.canConnect((LevelAccessor)worldIn, pos, Direction.DOWN)));
                worldIn.m_7731_(pos, state, 2);
            }
            BlockEntityHelper.get(ChannelBlockEntity.class, (BlockGetter)worldIn, (BlockPos)pos).ifPresent(te -> te.removeCachedNeighbor(Util.directionFromOffset(pos, fromPos)));
        }
    }

    @Deprecated
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return side.m_122434_().m_122479_() && adjacentBlockState.m_60713_((Block)this) && ((ChannelConnection)((Object)state.m_61143_((Property)DIRECTION_MAP.get(side)))).canFlow() && ((ChannelConnection)((Object)adjacentBlockState.m_61143_((Property)DIRECTION_MAP.get(side.m_122424_())))).canFlow();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ChannelBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> givenType) {
        return pLevel.f_46443_ ? null : BlockEntityHelper.castTicker(givenType, (BlockEntityType)((BlockEntityType)TinkerSmeltery.channel.get()), ChannelBlockEntity.SERVER_TICKER);
    }

    static {
        boolean[] bools;
        SIDE_IN = TConstruct.makeTranslation("block", "channel.side.in");
        SIDE_OUT = TConstruct.makeTranslation("block", "channel.side.out");
        SIDE_NONE = TConstruct.makeTranslation("block", "channel.side.none");
        DOWN_OUT = TConstruct.makeTranslation("block", "channel.down.out");
        DOWN_NONE = TConstruct.makeTranslation("block", "channel.down.none");
        SIDE_CONNECTION = Util.make(new EnumMap(ChannelConnection.class), map -> {
            map.put(ChannelConnection.IN, SIDE_IN);
            map.put(ChannelConnection.OUT, SIDE_OUT);
            map.put(ChannelConnection.NONE, SIDE_NONE);
        });
        DOWN = BlockStateProperties.f_61367_;
        POWERED = BlockStateProperties.f_61448_;
        NORTH = EnumProperty.m_61587_((String)"north", ChannelConnection.class);
        SOUTH = EnumProperty.m_61587_((String)"south", ChannelConnection.class);
        WEST = EnumProperty.m_61587_((String)"west", ChannelConnection.class);
        EAST = EnumProperty.m_61587_((String)"east", ChannelConnection.class);
        DIRECTION_MAP = Util.make(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, NORTH);
            map.put(Direction.SOUTH, SOUTH);
            map.put(Direction.WEST, WEST);
            map.put(Direction.EAST, EAST);
        });
        SIDE_BOUNDS = Util.make(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, Shapes.m_83113_((VoxelShape)ChannelBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)9.0, (double)4.0), (VoxelShape)ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0), (BooleanOp)BooleanOp.f_82685_));
            map.put(Direction.SOUTH, Shapes.m_83113_((VoxelShape)ChannelBlock.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0), (VoxelShape)ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)9.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_));
            map.put(Direction.WEST, Shapes.m_83113_((VoxelShape)ChannelBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)9.0, (double)10.0), (BooleanOp)BooleanOp.f_82685_));
            map.put(Direction.EAST, Shapes.m_83113_((VoxelShape)ChannelBlock.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0), (BooleanOp)BooleanOp.f_82685_));
        });
        VoxelShape centerUnconnected = Shapes.m_83148_((VoxelShape)ChannelBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.m_49796_((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0)), (BooleanOp)BooleanOp.f_82685_);
        VoxelShape centerConnected = Shapes.m_83148_((VoxelShape)ChannelBlock.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Shapes.m_83124_((VoxelShape)ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{ChannelBlock.m_49796_((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0), ChannelBlock.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), (BooleanOp)BooleanOp.f_82685_);
        VoxelShape northWall = ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)6.0);
        VoxelShape southWall = ChannelBlock.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)9.0, (double)12.0);
        VoxelShape westWall = ChannelBlock.m_49796_((double)4.0, (double)6.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0);
        VoxelShape eastWall = ChannelBlock.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
        BOUNDS = new VoxelShape[32];
        for (boolean down : bools = new boolean[]{false, true}) {
            VoxelShape center = down ? centerConnected : centerUnconnected;
            for (boolean north : bools) {
                VoxelShape northBounds = north ? SIDE_BOUNDS.get(Direction.NORTH) : northWall;
                for (boolean south : bools) {
                    VoxelShape southBounds = south ? SIDE_BOUNDS.get(Direction.SOUTH) : southWall;
                    for (boolean west : bools) {
                        VoxelShape westBounds = west ? SIDE_BOUNDS.get(Direction.WEST) : westWall;
                        for (boolean east : bools) {
                            VoxelShape eastBounds = east ? SIDE_BOUNDS.get(Direction.EAST) : eastWall;
                            ChannelBlock.BOUNDS[ChannelBlock.makeKey((boolean)down, (boolean)north, (boolean)south, (boolean)west, (boolean)east)] = Shapes.m_83124_((VoxelShape)center, (VoxelShape[])new VoxelShape[]{northBounds, southBounds, westBounds, eastBounds});
                        }
                    }
                }
            }
        }
    }

    public static enum ChannelConnection implements StringRepresentable
    {
        NONE,
        IN,
        OUT;


        public String m_7912_() {
            return this.toString().toLowerCase(Locale.US);
        }

        public boolean canFlow() {
            return this == IN || this == OUT;
        }

        public ChannelConnection getOpposite() {
            return switch (this) {
                case IN -> OUT;
                case OUT -> IN;
                default -> NONE;
            };
        }

        public ChannelConnection getNext(boolean reverse) {
            if (reverse) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case NONE -> OUT;
                    case OUT -> IN;
                    case IN -> NONE;
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> IN;
                case IN -> OUT;
                case OUT -> NONE;
            };
        }
    }
}

